/*********************************************************************
 *
 *                  Console Routines
 *
 *********************************************************************
 * FileName:        Console.h
 * Dependencies:	GenericTypeDefs.h, Compiler.h, RadioDriverDefs.h
 * Processor:       PIC18/PIC24
 * Complier:        MCC18 v1.00.50 or higher, C30 3.10 or higher
 *                  HITECH PICC-18 V8.10PL1 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 ********************************************************************/
#ifndef  _CONSOLE_H_
#define _CONSOLE_H_

#include "GenericTypeDefs.h"
#include "Compiler.h"
#include "RadioDriverDefs.h"

    #if defined(__PIC24F__)
		//This case is for PIC24 and processors working with Explorer 16 board
        void ConsoleInit(void);
        #define ConsoleIsPutReady()     (U2STAbits.TRMT)
        void ConsolePut(BYTE c);
        void ConsolePutROMString(ROM char* str);
    
        #define ConsoleIsGetReady()     (IFS1bits.U2RXIF)
        BYTE ConsoleGet(void);
        BYTE ConsoleInput(void);
        void PrintChar(BYTE);
        void PrintDigit(BYTE toPrint);
    #else
		//Case for PIC18 processors working with PICDEM Z board and Explorer 18 board
        void ConsoleInit(void);
        #define ConsoleIsPutReady()     (TRMT)
        void ConsolePut(BYTE c);
        void ConsolePutString(BYTE *s);
        void ConsolePutROMString(ROM char* str);
    
        #define ConsoleIsGetReady()     (RCIF)
        BYTE ConsoleGet(void);
        void PrintChar(BYTE);
        void PrintDigit(BYTE toPrint);
        BYTE ConsoleInput(void);
    #endif
#define c(a) ConsolePutROMString((ROM char*)a);
#define nl() ConsolePutROMString((ROM char*)"\r\n");
#endif




